<?php

namespace App\Modes\Case;

use Illuminate\Database\Eloquent\Model;

class Case extends Model 
{

    protected $table = 'cases';
    public $timestamps = true;

    public function disorders()
    {
        return $this->hasOne('CaseDisorder', 'case_id');
    }

    public function diagnoses()
    {
        return $this->hasMany('CaseDiagnoses', 'case_id');
    }

    public function simptoms()
    {
        return $this->hasMany('CaseSymptoms', 'case_id');
    }

    public function tasks()
    {
        return $this->hasMany('CaseTask', 'case_id');
    }

    public function doctors()
    {
        return $this->hasMany('CaseDoctors', 'case_id');
    }

    public function patient()
    {
        return $this->belongsTo('PAtient', 'id');
    }

    public function hospitalAdmissions()
    {
        return $this->hasMany('CaseHospitalAdmission', 'case_id');
    }

    public function tags()
    {
        return $this->hasMany('Tags', 'commentable_id');
    }

    public function flags()
    {
        return $this->hasMany('Flags', 'case_id');
    }

    public function notes()
    {
        return $this->morphedByMany('Notes', 'commentable_id');
    }

}